;==========================================================================
;Version history:
;==========================================================================
;2010/01/14     First edition
;2010/05/31     Rename the "D_MusicEvent" as "D_UserEvent"
;               Add new function "MIDI_EVENT"; use MIDI CH16 for MIDI events
;2010/10/12     Debug the macros "%MIDIPowerUpInitial" and %MIDIWakeUpInitial for RAM error
;2011/03/30     Add new function "MIDI_IOEvt" for declaring IO event in a MIDI
;==========================================================================
;MIDI Function Declaration
;==========================================================================
MIDI_EVENT:             .EQU    OFF             ;Declare MIDI Event function
MUTE_MIDI_CH:           .EQU    OFF             ;Declare Mute Channel Volume function
MIDI_KEY_SHIFT:         .EQU    OFF             ;Declare MIDI Key Shift function
CTRL_MIDI_CH_VOL:       .EQU    OFF             ;Declare Control Channel Volume function
PITCH_BEND:             .EQU    ON              ;Declare Pitch Bend function
REPEAT_MIDI:            .EQU    OFF             ;Declare Repeat MIDI function
MIDI_IOEvt:             .EQU    OFF             ;Declare IO Event in a MIDI
;==========================================================================
;Tempo change table
;==========================================================================
D_TempoIndexBegin:      .EQU    10D             ;20~10: tempo up
D_TempoIndexOffset:     .EQU    20D             ;Defaule tempo
D_TempoIndexEnd:        .EQU    30D             ;20~30: tempo down
;==========================================================================
;Envelope timebase can be adjusted according to the user settings in G+Midiar
;==========================================================================
D_ADSRTimeBase:         .EQU    05D             ;Must equal to the setting in G+ Midiar (Unit:ms)
D_NoteOffTimeBase:      .EQU    05D             ;Must equal to the setting in G+ Midiar (Unit:ms)
D_TimeBaseFactor:       .EQU    CPU_Clock/16000 ;(CPU_Clock*256)/1000/4096
;==========================================================================
;PAGE 0 Declaration
;==========================================================================
        .PAGE0
R_InstAddr:             .DS     2
R_InstTabAddr:          .DS     2

R_InstAddrIRQ:          .DS     2
R_InstTabAddrIRQ:       .DS     2

R_MIDIDPTR:             .DS     3
;==========================================================================
;MIDI Status
;==========================================================================
R_MIDIStatus:           .DS     1
 D_MIDIEn:              .EQU    10000000B       ;MIDI is enabled
 D_DeltaTime:           .EQU    01000000B       ;Bit6 = 1, not Delta-time data
 D_MusicOff:            .EQU    00100000B       ;Music off
 D_PlaySingleNote:      .EQU    00010000B       ;Unused
 D_DynaAllocOff:        .EQU    00001000B       ;D_DynaAllocOff = 1, dynamic allocation Off, otherwise dynamic allocation on
 D_NewestNoteOut:       .EQU    00000100B       ;D_NewestNoteOut = 1, Newest note out; D_NewestNoteOut = 0, check D_MinVolNoteOut
 D_MinVolNoteOut:       .EQU    00000010B       ;D_MinVolNoteOut = 1, minimum volume note out; D_MinVolNoteOut = 0, oldest note out
 D_UserEvent:           .EQU    00000001B       ;Indicate a user event is detected
;==========================================================================
R_MIDICtrl:             .DS     1
 D_PauseMIDI:           .EQU    00000001B       ;Used to pause a MIDI
 D_MIDIEvent:           .EQU    00000010B       ;Indicate a MIDI event is detected
;==========================================================================
;Channel Status definition
;==========================================================================
R_ChStatus:             .DS     D_ChannelNo
 D_NotePlaying:         .EQU    10000000B       ;Indicate a note is played
 D_NoteOffFlag:         .EQU    01000000B       ;Indicate a note is released
 D_AdpcmJumpPcm:        .EQU    00100000B       ;Indicate a note is ADPCM+PCM
 D_DrumPlaying:         .EQU    00010000B       ;Indicate a drum note is played
 D_TargetIsLastDrop:    .EQU    00001000B       ;Indicate the current target is the last drop in the envelope table
 D_ReachLastDrop:       .EQU    00000100B       ;Indicate the envelope is reach the last drop
 D_SkipIniNoteOffEnv:   .EQU    00000010B       ;Indicate the envelope of note off is initialized
 D_ZCJump:              .EQU    00000001B       ;Indicate a note is set as Zero Corssing
;==========================================================================
;MIDI Usage
;==========================================================================
        .DATA
R_SingleNote:           .DS     1               ;Used for playing single note
R_SingleDrum:           .DS     1               ;Used for playing single drum
R_ADSRTimeBase:         .DS     1               ;R_ADSRTimeBase = [D_TimeBaseFactorH]:[D_TimeBaseFactorL]*ADSR_TimeBase
R_NoteOffTimeBase:      .DS     1               ;R_NoteOffTimeBase = [D_TimeBaseFactorH]:[D_TimeBaseFactorL]*NoteOff_TimeBase
R_MIDIData:             .DS     1               ;MIDI data
R_1024IntCnt:           .DS     1               ;Flag for checking 1024 IRQ
R_DeltaTime:            .DS     2               ;Delta time counter
R_DTCounter:            .DS     1               ;If R_DTCounter = R_TempoIndex, deal with delta time
R_TempoIndex:           .DS     1               ;Save the interrupt count for counting the delta time
R_ADSROffset:           .DS     1               ;Offset of envelope table
R_ADSRChannel:          .DS     1               ;Backup channel for envelope
R_MIDITemp:             .DS     1               ;For temporary when a MIDI is played
R_MIDITempIRQ:          .DS     1               ;For temporary in IRQ when a MIDI is played
R_BackUpCh:             .DS     1               ;SPU channel of a note
R_BackUpChIRQ:          .DS     1               ;SPU channel of a note in IRQ
R_ConcChannel:          .DS     1               ;Check which channel is concatenate jump mode
R_ChInst:               .DS     16              ;Instrument index for 16 MIDI channels
R_DrumIndex:            .EQU    R_ChInst+9      ;For Drum usage

R_EnvTimeBase:          .DS     D_ChannelNo     ;Time counter for envelope updating
R_ChDrumIndex:          .DS     D_ChannelNo     ;Prevent drum index
R_Note:                 .DS     D_ChannelNo     ;Note pitch
R_InstIndex:            .DS     D_ChannelNo     ;Save the MIDI channel of each SPU channel when a MIDI is played
R_ChTime:               .DS     D_ChannelNo     ;Duration counter
R_VeloVol:              .DS     D_ChannelNo     ;Velocity X Volume
R_VolumeInteger:        .DS     D_ChannelNo     ;Integer of current volume
R_VolumeFloat:          .DS     D_ChannelNo     ;Float of current volume
R_SlopeInteger:         .DS     D_ChannelNo     ;Integer of envelope slope
R_SlopeFloat:           .DS     D_ChannelNo     ;Float of envelope slope
R_TargetInteger:        .DS     D_ChannelNo     ;Integer of envelope target
R_TargetFloat:          .DS     D_ChannelNo     ;Float of envelope target
R_TabOffset:            .DS     D_ChannelNo     ;Save the offset of envelope table
R_MidiDurationL:        .DS     D_ChannelNo     ;Low byte of note duration
R_MidiDurationH:        .DS     D_ChannelNo     ;High byte of note duration
;==========================================================================
;Multiplier
;==========================================================================
R_MultiplierH:          .DS     1
R_MultiplierM:          .DS     1
R_MultiplierL:          .DS     1

R_FaciendH:             .DS     1
R_FaciendM:             .DS     1
R_FaciendL:             .DS     1

R_ProductH:             .DS     1
R_ProductM:             .DS     1
R_ProductL:             .DS     1
;==========================================================================
;User Event (NRPN)
;==========================================================================
R_MainIndex:            .DS     1               ;Main index of user event for MIDI
R_SubIndex:             .DS     1               ;Sub index of user event for MIDI
;==========================================================================
;MIDI Event (MIDI CH16)
;==========================================================================
        .IF MIDI_EVENT = ON
R_MIDIEvent:            .DS     1
        .ENDIF
;==========================================================================
;Mute MIDI Channel
;==========================================================================
        .IF MUTE_MIDI_CH = ON
R_EnCh1ToCh8:           .DS     1
 D_DisMIDICh1:          .EQU    00000001B
 D_DisMIDICh2:          .EQU    00000010B
 D_DisMIDICh3:          .EQU    00000100B
 D_DisMIDICh4:          .EQU    00001000B
 D_DisMIDICh5:          .EQU    00010000B
 D_DisMIDICh6:          .EQU    00100000B
 D_DisMIDICh7:          .EQU    01000000B
 D_DisMIDICh8:          .EQU    10000000B

R_EnCh9ToCh16:          .DS     1
 D_DisMIDICh9:          .EQU    00000001B
 D_DisMIDICh10:         .EQU    00000010B
 D_DisMIDICh11:         .EQU    00000100B
 D_DisMIDICh12:         .EQU    00001000B
 D_DisMIDICh13:         .EQU    00010000B
 D_DisMIDICh14:         .EQU    00100000B
 D_DisMIDICh15:         .EQU    01000000B
 D_DisMIDICh16:         .EQU    10000000B
        .ENDIF
;==========================================================================
;MIDI Key Shift
;==========================================================================
        .IF MIDI_KEY_SHIFT = ON
R_KeyShift:             .DS     1
        .ENDIF
;==========================================================================
;Channel Volume Control
;==========================================================================
        .IF CTRL_MIDI_CH_VOL = ON
R_CtrlMIDIChVol:        .DS     1

R_CtrlVolCh1ToCh8:      .DS     1
 D_CtrlCh1Vol:          .EQU    00000001B
 D_CtrlCh2Vol:          .EQU    00000010B
 D_CtrlCh3Vol:          .EQU    00000100B
 D_CtrlCh4Vol:          .EQU    00001000B
 D_CtrlCh5Vol:          .EQU    00010000B
 D_CtrlCh6Vol:          .EQU    00100000B
 D_CtrlCh7Vol:          .EQU    01000000B
 D_CtrlCh8Vol:          .EQU    10000000B

R_CtrlVolCh9ToCh16:     .DS     1
 D_CtrlCh9Vol:          .EQU    00000001B
 D_CtrlCh10Vol:         .EQU    00000010B
 D_CtrlCh11Vol:         .EQU    00000100B
 D_CtrlCh12Vol:         .EQU    00001000B
 D_CtrlCh13Vol:         .EQU    00010000B
 D_CtrlCh14Vol:         .EQU    00100000B
 D_CtrlCh15Vol:         .EQU    01000000B
 D_CtrlCh16Vol:         .EQU    10000000B
        .ENDIF
;==========================================================================
;Pitch Bend
;==========================================================================
        .IF PITCH_BEND = ON
R_PitchBendMidiCh:      .DS     1               ;The MIDI Pitch Bend channle number
R_ChNoteFsL:            .DS     D_ChannelNo     ;FsL of note in SPU
R_ChNoteFsH:            .DS     D_ChannelNo     ;FsH of note in SPU
R_SpuMidiCh:            .DS     D_ChannelNo     ;Save the MIDI channel number of note in SPU channel
R_PitchBendLevel:       .DS     1               ;Pitch bend level of MIDI note
        .ENDIF
;==========================================================================
;Repeat MIDI
;==========================================================================
        .IF REPEAT_MIDI = ON
R_RepeatMIDI:           .DS     1               ;Bit[6:0] = MIDI index
 D_RepeatMIDI:          .EQU    10000000B       ;Bit7 is a Repeat On/Off flag
        .ENDIF
;==========================================================================
;Purpose: Initialize the RAMs which are used for playing MIDIs after power on
;Input: None
;Return: None
;Destroy: A, X
;==========================================================================
%MIDIPowerUpInitial:    .MACRO
        LDA     #D_TempoIndexOffset             ;Set default tempo
        STA     R_TempoIndex

        LDA     #00H
        STA     R_BackUpCh                      ;Initial channel number

        .IF MIDI_KEY_SHIFT = ON
        STA     R_KeyShift
        .ENDIF

        .IF CTRL_MIDI_CH_VOL = ON
        STA     R_CtrlMIDIChVol
        STA     R_CtrlVolCh1ToCh8
        STA     R_CtrlVolCh9ToCh16
        LDA     #D_DefaultVolumeLevel
        STA     R_CtrlMIDIChVol                 ;Set default control volume
        .ENDIF

        .IF PITCH_BEND = ON
        %InitPitchBendRAM
        .ENDIF

        LDA     P_INT_CtrlL                     ;Enable Fcpu/1024
        ORA     #D_TB1024IntEn
        STA     P_INT_CtrlL

        LDA     #04H
        STA     R_1024IntCnt                    ;For counting Fcpu/4096 interrupt

        LDA     #00H
        LDX     #D_ChannelNo
L_Clear?#:
        STA     R_ChTime-1,X
        DEX
        BNE     L_Clear?#
                        .ENDM
;==========================================================================
;Purpose: Initialize the RAMs which are used for playing MIDIs after wake-up
;Input: None
;Return: None
;Destroy: A, X
;==========================================================================
%MIDIWakeUpInitial:     .MACRO
        LDA     #D_TempoIndexOffset             ;Set default tempo
        STA     R_TempoIndex

        LDA     #00H
        STA     R_BackUpCh                      ;Initial channel number

        .IF MIDI_KEY_SHIFT = ON
        STA     R_KeyShift
        .ENDIF

        .IF CTRL_MIDI_CH_VOL = ON
        STA     R_CtrlMIDIChVol
        STA     R_CtrlVolCh1ToCh8
        STA     R_CtrlVolCh9ToCh16
        LDA     #D_DefaultVolumeLevel
        STA     R_CtrlMIDIChVol                 ;Set default control volume
        .ENDIF

        .IF PITCH_BEND = ON
        %InitPitchBendRAM
        .ENDIF

        LDA     P_INT_CtrlL                     ;Enable Fcpu/1024 IRQ
        ORA     #D_TB1024IntEn
        STA     P_INT_CtrlL

        LDA     #04H
        STA     R_1024IntCnt                    ;For counting Fcpu/4096 interrupt

        LDA     #00H
        LDX     #D_ChannelNo
L_Clear?#:
        STA     R_ChTime-1,X
        DEX
        BNE     L_Clear?#
                        .ENDM
;==========================================================================
;Purpose: Check if a MIDI is played
;Input: None
;Return: C = 0, no MIDI is played; C = 1, a MIDI is played
;Destroy: A
;==========================================================================
%TestMIDI:              .MACRO
        CLC
        LDA     R_MIDIStatus
        AND     #D_MIDIEn
        BEQ     L_NotPlay?
        SEC
L_NotPlay?
                        .ENDM
;==========================================================================
%ClearDeltaTimeFlag:    .MACRO
        LDA     R_MIDIStatus
        AND     #.NOT.D_DeltaTime
        STA     R_MIDIStatus
                        .ENDM
;==========================================================================
%ChkADSRTimeBase:       .MACRO                  ;By CPU_Clock/1024 X 4
        LDA     R_MIDIStatus                    ;Check if a MIDI is played
        AND     #D_MIDIEn
        BNE     L_GOTimeBase?
        LDA     R_SingleNote                    ;Check if a single note or drum is played
        ORA     R_SingleDrum
        BNE     L_GOTimeBase?
        JMP     L_ExitChkTimeBaseCh

L_GOTimeBase?:
        LDX     #00H
L_ChkChTimeBase:
        LDA     R_EnvTimeBase,X
        BEQ     L_ChkNextTimeBase
        DEC     R_EnvTimeBase,X                 ;Counter of Volume-Slope(update envelope per 5mSec)
L_ChkNextTimeBase:
        INX
        CPX     #D_ChannelNo
        BEQ     L_ExitChkTimeBaseCh
        JMP     L_ChkChTimeBase
L_ExitChkTimeBaseCh:
                        .ENDM
;==========================================================================
%MidiDataCounter:       .MACRO
        LDA     R_MIDIStatus
        AND     #D_MIDIEn
        BEQ     L_ExitDeltaTime#

        INC     R_DTCounter                     ;Adjust tempo
        LDA     R_DTCounter                     ;Counter for delta time(tick), adjust tempo by R_TempoIndex
        CMP     R_TempoIndex
        BNE     L_ExitDeltaTime#

        LDA     #00H
        STA     R_DTCounter                     ;Reset counter

        LDA     R_DeltaTime
        ORA     R_DeltaTime+1
        BEQ     L_DeltaTimeOut#?
        DEC     R_DeltaTime
        LDA     R_DeltaTime
        CMP     #FFH
        BNE     L_DeltaTimeOut#?
        DEC     R_DeltaTime+1
L_DeltaTimeOut#?:
        %ChkMidiDuration
L_ExitDeltaTime#:
        DEC     R_1024IntCnt
        BNE     L_Not4096#
        LDA     #04H
        STA     R_1024IntCnt
        %ChkADSRTimeBase                        ;Update Envelpoe
L_Not4096#:
                        .ENDM
;==========================================================================
%ChkMidiDuration:       .MACRO
        LDX     #D_ChannelNo-1
L_ChkChDuraLoop?:
        LDA     R_MidiDurationL,X
        BNE     L_DecLow?
        LDA     R_MidiDurationH,X
        BEQ     L_ChkNextChDura?
        DEC     R_MidiDurationH,X               ;Decrease duration
L_DecLow?:
        DEC     R_MidiDurationL,X
L_ChkNextChDura?:
        DEX
        BPL     L_ChkChDuraLoop?
                        .ENDM
;==========================================================================
%M_IncreaseAddr:        .MACRO  AddrLow,Offset
        CLC
        LDA     AddrLow
        ADC     Offset
        STA     AddrLow
        BCC     L_Quit1#
        INC     AddrLow+1
L_Quit1#:
                        .ENDM
;==========================================================================
%InitPitchBendRAM:      .MACRO
        LDX     #00H
L_InitRAM_Loop?:
        LDA     #FFH
        STA     R_SpuMidiCh,X                   ;Clear MIDI channel number of note in the SPU
        INX
        CPX     #D_ChannelNo
        BCC     L_InitRAM_Loop?
        LDA     #D_DefaultPBLevel
        STA     R_PitchBendLevel
                        .ENDM
;==========================================================================
%SetUpTimeBase:         .MACRO  ADSRTimeBase,NoteOffTimeBase
        LDA     #ADSRTimeBase
        STA     R_FaciendL
        LDA     #<D_TimeBaseFactor
        STA     R_MultiplierL
        LDA     #>D_TimeBaseFactor
        STA     R_MultiplierM
        %Multi8X16      R_FaciendL,R_MultiplierL,R_MultiplierM
        LDA     R_ProductM
        STA     R_ADSRTimeBase

        LDA     #NoteOffTimeBase
        STA     R_FaciendL
        LDA     #<D_TimeBaseFactor
        STA     R_MultiplierL
        LDA     #>D_TimeBaseFactor
        STA     R_MultiplierM
        %Multi8X16      R_FaciendL,R_MultiplierL,R_MultiplierM
        LDA     R_ProductM
        STA     R_NoteOffTimeBase
                        .ENDM
;==========================================================================
%Multi8X16:     .MACRO  Faciend,MultiplierL,MultiplierH
        LDA     Faciend
        STA     P_MulF
        LDA     MultiplierL
        STA     P_MulM
        LDA     #D_MulAct
        STA     P_MulAct
L_WaitL#:
        BIT     P_MulAct
        BNE     L_WaitL#
        LDA     P_MulOutL
        STA     R_ProductL
        LDA     P_MulOutH
        STA     R_ProductM

        LDA     MultiplierH
        STA     P_MulM
        LDA     #D_MulAct
        STA     P_MulAct
L_WaitH#:
        BIT     P_MulAct
        BNE     L_WaitH#
        CLC
        LDA     P_MulOutL
        ADC     R_ProductM
        STA     R_ProductM
        LDA     #00H
        ADC     P_MulOutH
        STA     R_ProductH
                .ENDM
;==========================================================================
%Multi16X16:     .MACRO  FaciendL,FaciendH,MultiplierL,MultiplierH
        LDA     FaciendL
        STA     P_MulF
        LDA     MultiplierL
        STA     P_MulM
        LDA     #D_MulAct
        STA     P_MulAct
L_WaitLL#:
        BIT     P_MulAct
        BNE     L_WaitLL#
        LDA     P_MulOutL
        STA     R_ProductL
        LDA     P_MulOutH
        STA     R_ProductM

        LDA     MultiplierH
        STA     P_MulM
        LDA     #D_MulAct
        STA     P_MulAct
L_WaitLH#:
        BIT     P_MulAct
        BNE     L_WaitLH#
        CLC
        LDA     P_MulOutL
        ADC     R_ProductM
        STA     R_ProductM
        LDA     #00H
        ADC     P_MulOutH
        STA     R_ProductH

        LDA     FaciendH
        STA     P_MulF
        LDA     #D_MulAct
        STA     P_MulAct
L_WaitHH#:
        BIT     P_MulAct
        BNE     L_WaitHH#
        CLC
        LDA     P_MulOutL
        ADC     R_ProductH
        STA     R_ProductH

        LDA     MultiplierL
        STA     P_MulM
        LDA     #D_MulAct
        STA     P_MulAct
L_WaitHL#:
        BIT     P_MulAct
        BNE     L_WaitHL#
        CLC
        LDA     P_MulOutL
        ADC     R_ProductM
        STA     R_ProductM
        LDA     P_MulOutH
        ADC     R_ProductH
        STA     R_ProductH
                .ENDM
;==========================================================================
